/*
 * Decompiled with CFR 0.152.
 */
package com.plasmoverse.lib.config;

import com.plasmoverse.lib.config.CommonConfig;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/plasmoverse/lib/config/VelocityConfig;", "T", "", "Lcom/plasmoverse/lib/config/CommonConfig;", "plugin", "dataDirectory", "Ljava/nio/file/Path;", "configClass", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/nio/file/Path;Ljava/lang/Class;)V", "configFolder", "Ljava/io/File;", "getConfigFolder", "()Ljava/io/File;", "getResourceStream", "Ljava/io/InputStream;", "path", "", "velocity"})
public final class VelocityConfig<T>
extends CommonConfig<T> {
    @NotNull
    private final Object plugin;
    @NotNull
    private final File configFolder;

    public VelocityConfig(@NotNull Object plugin, @NotNull Path dataDirectory, @NotNull Class<T> configClass) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        super(configClass, null, null, 6, null);
        this.plugin = plugin;
        File file = dataDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dataDirectory.toFile()");
        this.configFolder = file;
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Override
    @NotNull
    public InputStream getResourceStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = this.plugin.getClass().getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new Exception(Intrinsics.stringPlus((String)"Failed to load resource: ", (Object)path));
        }
        return inputStream;
    }
}

